#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <assert.h>

#include "goblin_army.h"
#include "ga_goblin.h"
#include "ga_world.h"


void new_round(struct world* w) {
  struct goblin_list *goblin_iterator;
  for(goblin_iterator = w->goblins; goblin_iterator; goblin_iterator = goblin_iterator->next) {
    assert(goblin_iterator->goblin);
    goblin_action(w, goblin_iterator->goblin);
  }
}

int main(int argc, char**argv) {
  struct world w;
  //  srand(getpid());
  world_init(&w);

  world_print(&w);
  double duration = 0;
  struct timespec t1, t2;

  for(int tour=0; tour<75; tour++) {
    usleep(200000);
    clear_screen();
    printf("\nRound %d \t Nb goblins: %d\tduration of last round: %lf ms\n", tour, w.nb_goblins, duration *1e3);
    clock_gettime(CLOCK_MONOTONIC, &t1);
    new_round(&w);
    clock_gettime(CLOCK_MONOTONIC, &t2);
    duration = t2.tv_sec - t1.tv_sec + (t2.tv_nsec - t1.tv_nsec)/1e9;
    world_print(&w);
  }
  
  return EXIT_SUCCESS;
}
