#include <stdio.h>
#include <assert.h>
#include "goblin_army.h"
#include "ga_route.h"
#include "ga_goblin.h"

/* Insert a goblin in a list. Return the new list */
struct goblin_list* goblin_list_insert(struct goblin_list* list, struct goblin* g) {
  struct goblin_list* new_node = malloc(sizeof(struct goblin_list));
  new_node->goblin = g;
  new_node->next = list;
  return new_node;
}

/* Remove a goblin from a list. Return the new list */
struct goblin_list* goblin_list_remove(struct goblin_list*list, struct goblin* g) {
  if(!list) return NULL;

  if(list->goblin == g){
    struct goblin_list* retval = list->next;
    free(list);
    return retval;
  }

  list->next = goblin_list_remove(list->next, g);
  return list;
}

/* Initialize a goblin */
void goblin_init(struct goblin*g,
		 struct location* l,
		 struct location* src,
		 struct location* dest) {
  g->location = l;
  static int next_goblin_id = 0;
  g->id = next_goblin_id++;
  g->bag = 0;
  g->src = src;
  g->dest = dest;
  g->status = to_src;
  g->cur_dest = src;
}

/* Create goblin */
struct goblin* goblin_create(struct world* w, struct location* l,
			     struct location* src, struct location* dest) {
  struct goblin*g = malloc(sizeof(struct goblin));
  goblin_init(g, l, src, dest);
  w->goblins = goblin_list_insert(w->goblins, g);
  w->nb_goblins ++;
  l->goblins = goblin_list_insert(l->goblins, g);
  return g;
}

/* move a goblin (one step) */
static void goblin_move(struct world* w, struct goblin *g) {
  struct location* next_location = g->location;

  /* TODO: implement goblin deplacement.
   * We may have to call compute_new_route_goblin() to find a route between g->location and
   * g->cur_dest
   */

  /* remove g from the current location */
  g->location->goblins = goblin_list_remove(g->location->goblins, g);
  /* add g to the next location */
  next_location->goblins = goblin_list_insert(next_location->goblins, g);
  g->location = next_location;
}

/* Perform one round for a goblin */
void goblin_action(struct world* w, struct goblin *g){

  /* A goblin is a simple being. It either:
   *  - fill its bag with a resource (iron, wood, stone) from a resource location (mine,
   *    forest, quarry)
   *  - empty its bag to a location that consume a resource (forge, sawfill, cathedral)
   *  - or walk from/to the resource location
   */

  switch(g->status) {
  case filling:
    if(g->bag < BAG_CAPACITY) {
      /* Encore du travail ? */

      /* Keep filling the bag */
      g->bag = min(g->bag + BAG_FILL_SPEED, BAG_CAPACITY);
    } else {
      /* Bag is full, let's go empty it */
      g->status = to_dest;
      g->cur_dest = g->dest;
      dprintf("goblin %d starts their journey to (%d,%d)\n",
	      g->id, g->cur_dest->i, g->cur_dest->j);
    }
    break;
  case emptying:
    if(g->bag > 0) {
      /* Du travail, encore du travail */

      /* Empty the bag */
      g->bag = max(g->bag - BAG_EMPTY_SPEED, 0);
    } else {
      /* Bag is empty, go back to the ressource */
      g->status = to_src;
      g->cur_dest = g->src;
      dprintf("goblin %d starts their journey to (%d,%d)\n",
	      g->id, g->cur_dest->i, g->cur_dest->j);
    }
    break;
  case to_src:
    if(g->location == g->src) {
      /* goblin reached the source. Start filling the bag */
      dprintf("goblin %d reached their destination (%d,%d)\n",
	      g->id, g->cur_dest->i, g->cur_dest->j);
      assert(g->location == g->cur_dest);

      g->status = filling;      
    } else {      
      goblin_move(w, g);
    }
    break;
  case to_dest:
    if(g->location == g->dest) {
      /* goblin reached the dest. Start emptying the bag */
      dprintf("goblin %d reached their destination (%d,%d)\n",
	      g->id, g->cur_dest->i, g->cur_dest->j);
      assert(g->location == g->cur_dest);

      g->status = emptying;
    } else {
      goblin_move(w, g);
    }
    break;
  }
}
