#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <time.h>

#define CITY_NAME_MAX_LEN 32

struct city {
  char name[CITY_NAME_MAX_LEN];
  float min_temp;
  float max_temp;
  float total_temp;
  float mean_temp;
  int count;
};


/* print a city in json format */
void print_city(FILE* output_stream, struct city* city) {
  fprintf(output_stream, "{\"city\": \"%s\", \"min\": %.1f, \"max\": %.1f, \"mean\": %.1f}",
	  city->name, city->min_temp, city->max_temp, city->mean_temp);  
}

/* Write the list of cities and their data (in JSON) to output_file*/
void print_cities(const char* output_file) {
  /* TODO */
}


int main(int argc, char**argv) {
  char* input_file = "measurements.csv";
  char* output_file = "output_file.csv";
  if(argc > 1) {
    input_file = argv[1];
  }
  
  int nb_measurements = 0;
  struct timespec t1, t2;
  clock_gettime(CLOCK_MONOTONIC, &t1);

  /* TODO: process input_file */

  print_cities(output_file);

  clock_gettime(CLOCK_MONOTONIC, &t2);
  double duration = t2.tv_sec - t1.tv_sec + (t2.tv_nsec - t1.tv_nsec)/1e9;
  printf("%d measurements processed in %lf s (%lf ns per measurement)\n",
	 nb_measurements, duration, duration*1e9/nb_measurements);
  return EXIT_SUCCESS;
}
