#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <setjmp.h>
#include "cmocka.h"

#include "goblin_army.h"
#include "ga_goblin.h"
#include "ga_world.h"

void test_world_init(void** state) {
  /* Test whether world_init works as intended  */
  struct world w;
  world_init(&w);

  assert_int_equal(w.width, WORLD_WIDTH);
  assert_int_equal(w.height, WORLD_HEIGHT);
  for(int i=0; i<w.width; i++) {
    for(int j=0; j<w.height; j++) {
      struct location *l = &w.map[i][j];
      assert_int_equal(l->i, i);
      if(l->j != j) {
	abort();
      }
      assert_int_equal(l->j, j);
      assert_in_range(l->location_content, none, rock);
    }
  }
}

void test_goblin_action(void** state) {
  struct world w;
  world_init(&w);

  /* pick the first goblin */
  struct goblin_list *goblin_iterator = w.goblins;
  assert_non_null(goblin_iterator->goblin);
  struct goblin *g = goblin_iterator->goblin;

  /* get the current status/location of the goblin */
  enum goblin_status g_status = g->status;
  struct location* l = g->location;

  /* perform one action on this goblin */
  goblin_action(&w, g);

  /* the status or location should have changed */
  enum goblin_status new_g_status = g->status;
  struct location* new_l = g->location;

  int goblin_moved =  new_l == l ? 0: 1;
  int goblin_status_changed =  new_g_status == g_status ? 0: 1;
  assert_int_equal( goblin_moved * goblin_status_changed, 1);
}

int main(int argc, char**argv) {
  const struct CMUnitTest tests[] = {
    /* a few tests for goblin army.
     *
     * If you implemented correctly the functions, all these tests should be successfull
     * Of course this test suite may not cover all the tricky cases, and you should add
     * your own tests.
     */
    cmocka_unit_test(test_world_init),
    cmocka_unit_test(test_goblin_action)
  };
  return cmocka_run_group_tests(tests, NULL, NULL);
}
