#include <stdio.h>
#include "goblin_army.h"
#include "ga_goblin.h"
#include "ga_world.h"

/* Initialize a location */
static void location_init(struct location* l, int i, int j) {
  l->i = i;
  l->j = j;
  l->goblins = NULL;
  l->location_content = none;
}

/* Find an empty location at a random place */
static struct location* get_random_empty_location(struct world* w) {
  int i;
  int j;
  do {
    i=rand()%WORLD_WIDTH;
    j=rand()%WORLD_HEIGHT;
  } while(w->map[i][j].location_content != none) ;
  return &w->map[i][j];
}


/* Create a location_content at a random place */
static struct location* create_random_location_content(struct world* w,
						       enum location_content lc) {
  struct location* l = get_random_empty_location(w);
  l->location_content = lc;
  return l;
}

/* Create a bunch of mountains */
static void create_mountains(struct world* w) {
  /* TODO: implement mountains */
}

/* Create a new world */
void world_init(struct world* w) {
  printf("Initializing world (%d x %d)\n", WORLD_WIDTH, WORLD_HEIGHT);
  w->width = WORLD_WIDTH;
  w->height = WORLD_HEIGHT;
  w->goblins = NULL;
  w->nb_goblins = 0;
  w->map = malloc(sizeof(struct location*) * w->width);
  for(int i = 0; i<w->width; i++) {
    w->map[i] = malloc(sizeof(struct location)*w->height);
    for(int j = 0; j<w->height; j++) {
      location_init(&w->map[i][j], i, j);
    }
  }

  /* Create rocks */
  printf("...Creating %d mountains\n", NB_ROCKS);
  for(int i=0; i<NB_ROCKS; i++) {
    create_mountains(w);
  }

  /* Create resources (mines, forest, quarries) */
  printf("...Creating %d mines\n", NB_MINES);
  struct location* mines[NB_MINES];
  for(int i=0; i<NB_MINES; i++) {
    mines[i] = create_random_location_content(w, mine);
  }

  printf("...Creating %d forests\n", NB_FORESTS);
  struct location* forests[NB_FORESTS];
  for(int i=0; i<NB_FORESTS; i++) {
    forests[i] = create_random_location_content(w, forest);
  }

  printf("...Creating %d quarries\n", NB_QUARRIES);
  struct location* quarries[NB_QUARRIES];
  for(int i=0; i<NB_QUARRIES; i++) {
    quarries[i] = create_random_location_content(w, quarry);
  }

  /* Create workplaces (forges, sawfills, cathedrals) */
  printf("...Creating %d forges\n", NB_FORGES);
  struct location* forges[NB_FORGES];
  for(int i=0; i<NB_FORGES; i++) {
    forges[i] = create_random_location_content(w, forge);
    /* create 2 goblins that fill the forge */
    for(int j=0; j<NB_GOBLIN_PER_FORGE; j++) {
      struct location* l = get_random_empty_location(w);
      struct location* src= mines[rand()%NB_MINES];
      goblin_create(w, l, src, forges[i]);
    }
  }

  printf("...Creating %d sawfills\n", NB_SAWFILLS);
  struct location* sawfills[NB_SAWFILLS];
  for(int i=0; i<NB_SAWFILLS; i++) {
    sawfills[i] = create_random_location_content(w, sawfill);
    /* create 2 goblins that fill the sawfill */
    for(int j=0; j<NB_GOBLIN_PER_SAWFILL; j++) {
      struct location* l = get_random_empty_location(w);
      struct location* src= forests[rand()%NB_FORESTS];
      goblin_create(w, l, src, sawfills[i]);
    }
  }

  printf("...Creating %d cathedrals\n", NB_CATHEDRALS);
  struct location* cathedrals[NB_CATHEDRALS];
  for(int i=0; i<NB_CATHEDRALS; i++) {
    cathedrals[i] = create_random_location_content(w, cathedral);
    /* create 2 goblins that fill the cathedral */
    for(int j=0; j<NB_GOBLIN_PER_CATHEDRAL; j++) {
      struct location* l = get_random_empty_location(w);
      struct location* src= quarries[rand()%NB_QUARRIES];
      goblin_create(w, l, src, cathedrals[i]);
    }
  }
  printf("Initializing world: done\n");
}

/* Display a world */
void world_print(struct world* w) {
#if NO_DISPLAY
  return;
#endif
  printf("+");
  for(int i=0; i<w->width; i++) {
    printf("-");
  }
  printf("+\n");
  for(int j=0; j<w->height; j++) {
    printf("|");
    for(int i=0; i<w->width; i++) {
      struct location *l = &w->map[i][j];

      char to_print=' ';
      
      switch(l->location_content) {
      case none: to_print=' '; break;
      case mine: to_print='M'; break;
      case forest: to_print='f'; break;
      case quarry: to_print='Q'; break;
      case forge: to_print='F'; break;
      case sawfill: to_print='S'; break;
      case cathedral: to_print='C'; break;
      case rock: to_print='R'; break;
      }
      if(to_print == ' ' && l->goblins) {
	to_print='G';
      }
      printf("%c", to_print);
    }
    printf("|\n");
  }
  printf("+");
  for(int i=0; i<w->width; i++) {
    printf("-");
  }
  printf("+\n");
}
