/*
 * compteurBOOM_v1_2_threads.c
 *
 * Version multithread avec 2 threads.
 */

#include <error.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <assert.h>

#define FINAL_COUNTER 200000000
#define NB_THREAD 2

int counter = 0;

void *start_routine(void *arg) {
  int i;

  for (i = 0; i < FINAL_COUNTER / NB_THREAD; i++) {
      /* OOPS: WRONG ! Access to an unprotected shared variable */
      counter ++;
    }
  pthread_exit(NULL);
}

int main (int argc, char *argv[]) {
  int rc;
  pthread_t thread1, thread2;
  
  assert(FINAL_COUNTER % NB_THREAD == 0); // Pour verifier que, si on repartit le travail d'incrementation de counter entre NB_THREAD, on est certain d'obtenir FINAL_COUNTER.
  
  rc = pthread_create(&thread1, NULL, start_routine, NULL);
  if (rc)
    error(EXIT_FAILURE, rc, "pthread_create");

  rc = pthread_create(&thread2, NULL, start_routine, NULL);
  if (rc)
    error(EXIT_FAILURE, rc, "pthread_create");

  rc = pthread_join(thread1, NULL);
  if (rc)
    error(EXIT_FAILURE, rc, "pthread_join");
  rc = pthread_join(thread2, NULL);
  if (rc)
    error(EXIT_FAILURE, rc, "pthread_join");

  if (counter != FINAL_COUNTER)
    printf("BOOM! counter = %d\n", counter);
  else
    printf("OK counter = %d\n", counter);

  exit(EXIT_SUCCESS);
}
