#ifndef GOBLIN_ARMY_GOBLIN_H
#define GOBLIN_ARMY_GOBLIN_H

#include "goblin_army.h"

/* Insert a goblin in a list. Return the new list */
struct goblin_list* goblin_list_insert(struct goblin_list* list, struct goblin* g);
/* Remove a goblin from a list. Return the new list */
struct goblin_list* goblin_list_remove(struct goblin_list* list, struct goblin* g);

/* Initialize a goblin */
void goblin_init(struct goblin*g, struct location* l, struct location* src, struct location* dest);
/* Create goblin */
struct goblin* goblin_create(struct world* w, struct location* l, struct location* src, struct location* dest);

/* Perform one round for a goblin */
void goblin_action(struct world* w, struct goblin *g);

#endif /* GOBLIN_ARMY_GOBLIN_H */
